<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CNICs with Spaces</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
 <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.all.voters') }}">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('userManagement') }}">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="{{ route('admin.manageUsers') }}">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.cnicWithSpaces') }}">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.duplicateCnic') }}">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.createUser') }}">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.polling_stations.index') }}">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.block_code.index') }}">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.ward.index') }}">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="{{ route('admin.logout') }}" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>
<body>
    <div class="container">
        <h3>CNIC Records with Spaces</h3>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>CNIC</th>
                    <th>Address</th>
                </tr>
            </thead>
            <tbody>
                @foreach($votersWithSpaces as $voter)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $voter->name }}</td>
                        <td>{{ $voter->cnic }}</td>
                        <td>{{ $voter->address }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</body>
</html>
