<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
               <a class="navbar-brand" href="#">Couponcode24 Blog Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.all.voters') }}">All Blogs Data</a>
                </li>
                
                 <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.createUser') }}">Create User</a>
                </li>
         
                
                <li class="nav-item">
                <form action="{{ route('admin.logout') }}" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Create User Form -->
    <div class="container mt-5">
        <h3>Create New User</h3>

        <form action="{{ route('admin.createUser.store') }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="name">Full Name</label>
                <input type="text" name="name" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirm Password</label>
                <input type="password" name="password_confirmation" class="form-control" required>
            </div>

            <!-- <div class="form-group">
                <label for="polling_station">Polling Station</label>
                <select name="polling_station" class="form-control">
                    <option value="">Select a Polling Station</option>
                    @foreach($pollingStations as $station)
                        <option value="{{ $station->id }}">{{ $station->polling_station_name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label for="block_code">Block Code</label>
                <select name="block_code" class="form-control">
                    <option value="">Select a Block Code</option>
                    @foreach($blockCodes as $block)
                        <option value="{{ $block->id }}">{{ $block->block_code }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label for="ward_no">Ward No</label>
                <select name="ward_no" class="form-control">
                    <option value="">Select a Ward</option>
                    @foreach($wards as $ward)
                        <option value="{{ $ward->id }}">{{ $ward->ward_number}}</option>
                    @endforeach
                </select>
            </div> -->

            <div class="form-group">
                <label for="gender">Gender</label>
                <select name="gender" class="form-control">
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                    <option value="Other">Other</option>
                </select>
            </div>

            <!-- <div class="form-group">
                <label for="gender">Entry Gender</label>
                <select name="entry_gender" class="form-control">
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                    <option value="Other">Other</option>
                </select>
            </div> -->

            <button type="submit" class="btn btn-primary">Create User</button>
        </form>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
