<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppUserController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\VotersDataController;




/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::post('/app-users/register', [AppUserController::class, 'register']);
Route::post('/app-users/login', [AppUserController::class, 'login']);
Route::get('/app-users/searchWithCnic/{cnic}', [AppUserController::class, 'searchWithCnic']);

Route::get('/api/hit-count/redis', [AdminDashboardController::class, 'countApiHitsRedis']);
Route::get('/api/hit-count/database', [AdminDashboardController::class, 'countApiHitsDatabase']);




Route::get('/blogs', [VotersDataController::class,'getBlogs']);
Route::get('/blog/{id}', [VotersDataController::class,'getSingleBlog']);



// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
