<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>

     <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>


    <!-- Edit User Form -->
    <div class="container mt-5">
        <h3>Edit Voter Entry Form For Administration</h3>
        
    <form action="<?php echo e(route('admin.updateVoter', $voter->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
          <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>
    <div class="form-group">
        <label for="name">Name</label>
        <input type="text" class="form-control" id="name" name="name" value="<?php echo e($voter->name); ?>" required>
    </div>

    <div class="form-group">
        <label for="father_name">Father's Name</label>
        <input type="text" class="form-control" id="father_name" name="father_name" value="<?php echo e($voter->father_name); ?>" required>
    </div>

    <div class="form-group">
        <label for="cnic">CNIC</label>
        <input type="text" class="form-control" id="cnic" name="cnic" value="<?php echo e($voter->cnic); ?>" required>
    </div>

  <div class="form-group">
    <label for="polling_station">Polling Station</label>
    <select class="form-control" id="polling_station" name="polling_station" required>
        <?php $__currentLoopData = $pollingStations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($station->polling_station_name); ?>" <?php echo e($voter->polling_station == $station->polling_station_name ? 'selected' : ''); ?>>
                <?php echo e($station->polling_station_name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="form-group">
    <label for="block_code">Block Code</label>
    <select class="form-control" id="block_code" name="block_code" required>
        <?php $__currentLoopData = $blockCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($block->block_code); ?>" <?php echo e($voter->block_code == $block->block_code ? 'selected' : ''); ?>>
                <?php echo e($block->block_code); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="form-group">
    <label for="ward_no">Ward No</label>
    <select class="form-control" id="ward_no" name="ward_no" required>
        <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($ward->ward_number); ?>" <?php echo e($voter->ward_no == $ward->ward_number ? 'selected' : ''); ?>>
                <?php echo e($ward->ward_number); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

    <div class="form-group">
        <label for="gender">Gender</label>
        <select class="form-control" id="gender" name="gender" required>
            <option value="Male" <?php echo e($voter->gender == 'Male' ? 'selected' : ''); ?>>Male</option>
            <option value="Female" <?php echo e($voter->gender == 'Female' ? 'selected' : ''); ?>>Female</option>
        </select>
    </div>

    <div class="form-group">
        <label for="gharana_number">Gharana Number</label>
        <input type="text" class="form-control" id="gharana_number" name="gharana_number" value="<?php echo e($voter->gharana_number); ?>">
    </div>

    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" name="address" value="<?php echo e($voter->address); ?>">
    </div>

    <div class="form-group">
        <label for="age">Age</label>
        <input type="number" class="form-control" id="age" name="age" value="<?php echo e($voter->age); ?>" required>
    </div>

    <div class="form-group">
        <label for="silsila_number">Silsila Number</label>
        <input type="text" class="form-control" id="silsila_number" name="silsila_number" value="<?php echo e($voter->silsila_number); ?>">
    </div>

    

    <button type="submit" class="btn btn-primary">Update Voter Entry</button>
</form>
 </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
<?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/voters/edit.blade.php ENDPATH**/ ?>