<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">Admin Panel</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#">Manage Users</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#">Settings</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Edit User Form -->
    <div class="container mt-5">
        <h3>Edit User</h3>

        <form action="<?php echo e(route('admin.updateUser', $user->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>  <!-- To specify this is a PUT request -->

            <div class="form-group">
                <label for="name">Full Name</label>
                <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $user->name)); ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $user->email)); ?>" required>
            </div>

            <div class="form-group">
                <label for="password">Password (Leave blank to keep current password)</label>
                <input type="password" name="password" class="form-control">
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirm Password</label>
                <input type="password" name="password_confirmation" class="form-control">
            </div>

            <div class="form-group">
                <label for="polling_station">Polling Station</label>
                <input type="text" name="polling_station" class="form-control" value="<?php echo e(old('polling_station', $user->polling_station)); ?>">
            </div>

            <div class="form-group">
                <label for="block_code">Block Code</label>
                <input type="text" name="block_code" class="form-control" value="<?php echo e(old('block_code', $user->block_code)); ?>">
            </div>

            <div class="form-group">
                <label for="ward_no">Ward No</label>
                <input type="text" name="ward_no" class="form-control" value="<?php echo e(old('ward_no', $user->ward_no)); ?>">
            </div>

            <div class="form-group">
                <label for="gender">Gender</label>
                <select name="gender" class="form-control">
                    <option value="Male" <?php echo e(old('gender', $user->gender) == 'Male' ? 'selected' : ''); ?>>Male</option>
                    <option value="Female" <?php echo e(old('gender', $user->gender) == 'Female' ? 'selected' : ''); ?>>Female</option>
                    <option value="Other" <?php echo e(old('gender', $user->gender) == 'Other' ? 'selected' : ''); ?>>Other</option>
                </select>
            </div>
            <div class="form-group">
                <label for="gender">Entry Gender</label>
                <select name="entry_gender" class="form-control">
                    <option value="Male" <?php echo e(old('gender', $user->entry_gender) == 'Male' ? 'selected' : ''); ?>>Male</option>
                    <option value="Female" <?php echo e(old('gender', $user->entry_gender) == 'Female' ? 'selected' : ''); ?>>Female</option>
                    <option value="Other" <?php echo e(old('gender', $user->entry_gender) == 'Other' ? 'selected' : ''); ?>>Other</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary">Update User</button>
        </form>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
<?php /**PATH C:\laragon\www\electionManagemntSystem\resources\views/admin/edit-user.blade.php ENDPATH**/ ?>