<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <style>
    .container-fluid{
        padding:20px;
        
    }
        html, body {
            width: 100%;
            height: 100%;
        }

        .container {
            width: 100%;
            padding-left: 15px;
            padding-right: 15px;
        }
        #votersTable {
    width: 100% !important; /* Ensure the table takes full width */
    table-layout: fixed;    /* Ensures table width is distributed evenly */
}

.table-responsive {
    overflow-x: auto; /* Ensures that horizontal scrolling is enabled for small screens */
}

.table th, .table td {
    text-align: center;  /* Ensures content is centered */
}
    </style>
</head>
<body>

    <!-- Navbar -->
     <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
               <a class="navbar-brand" href="#"> Blog Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.all.voters') }}">All Blogs Data</a>
                </li>
                
                 <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.createUser') }}">Create User</a>
                </li>
         
                
                <li class="nav-item">
                <form action="{{ route('admin.logout') }}" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Dashboard Content -->
    <div class="container-fluid">
         <center>
        <h3>Admin Dashboard</h3>
        <br>
          
        <div class="col-md-12 text-center" >
            <div class="card">
                <div class="card-header">
                    <h5>All Blogs Entries</h5>
                </div>
                <div class="card-body col-md-12">
                 
                    <table id="votersTable" class="table table-striped table-responsive text-center w-100">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>UserName</th>
                                
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($blogs_data as $record)
                                <tr>
                            
                                    <td>{{ $loop->iteration }}</td>
                                  
                                    <td>{{ $record->title }}</td>
                                    <td>{{ $record->user->name }}</td>
                                    <td>
                                        <a href="{{ route('admin.editVoter', $record->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                        <a href="{{ route('admin.showVoter', $record->id) }}" class="btn btn-info btn-sm">View</a>
                                        <form action="{{ route('admin.deleteVoter', $record->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this record?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
           </center>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Initialize DataTables -->
    <script>
        $(document).ready(function() {
            $('#usersTable, #votersTable').DataTable({
                "paging": true,
                "ordering": true,
                "info": true,
                "searching": true
            });
        });
    </script>

</body>
</html>
