<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-9">
                <center><h3>Blog'S Management System</h3></center>
                <div class="card">
                    <div class="card-header">Sign Up</div>
                    <div class="card-body">
                    <form action="{{ route('signup') }}" method="POST">
                        @csrf
                        <!-- Full Name -->
                        <div class="form-group">
                            <label for="name">Full Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                            @error('name') <div class="alert alert-danger">{{ $message }}</div> @enderror
                        </div>

                        <!-- Email -->
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
                            @error('email') <div class="alert alert-danger">{{ $message }}</div> @enderror
                        </div>

                        <!-- Password -->
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" name="password" class="form-control" required>
                            @error('password') <div class="alert alert-danger">{{ $message }}</div> @enderror
                        </div>

                        <!-- Confirm Password -->
                        <div class="form-group">
                            <label for="password_confirmation">Confirm Password</label>
                            <input type="password" name="password_confirmation" class="form-control" required>
                        </div>

                      
                        <!-- Gender -->
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select name="gender" class="form-control">
                                <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                                <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                                <option value="Other" {{ old('gender') == 'Other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>

                        
                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary btn-block">Sign Up</button>
                    </form>

                    <div class="mt-3 text-center">
                        <a href="{{ route('login') }}" class="btn btn-secondary">Already have an account? Login</a>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
