<!-- resources/views/admin/duplicate_cnic.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Duplicate CNIC Records</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
     <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>
    <div class="container mt-4">
        <h2>Duplicate CNIC Records</h2>
  
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Original CNIC</th>
                    <th>CNIC without Spaces</th>
                     <th>Block Code</th>
                     <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $duplicateCnics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($record->id); ?></td>
                        <td><?php echo e($record->original_cnic); ?></td>
                        <td><?php echo e($record->clean_cnic); ?></td>
                        <td><?php echo e($record->block_code); ?></td>
            <td>
                <!-- You can add actions here like Edit or View -->
                <a href="<?php echo e(route('admin.showVoter', $record->id)); ?>" class="btn btn-info btn-sm">View</a>
                 
                <!-- Delete Button -->
                <form action="<?php echo e(route('admin.deleteVoter', $record->id)); ?>" method="POST" style="display:inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                </form>
            </td>
            
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/duplicate_cnic.blade.php ENDPATH**/ ?>