<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CNICs with Spaces</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
 <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>
<body>
    <div class="container">
        <h3>CNIC Records with Spaces</h3>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>CNIC</th>
                    <th>Address</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $votersWithSpaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($voter->name); ?></td>
                        <td><?php echo e($voter->cnic); ?></td>
                        <td><?php echo e($voter->address); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/cnic_with_spaces.blade.php ENDPATH**/ ?>