<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Include TinyMCE CDN -->
    <script src="https://cdn.tiny.cloud/1/jm8hj5vtr9jlghx0o9otagozo1ikzupsv46f3bvdb2qqawmc/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <!-- Add Bootstrap's modal and other necessary styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
             <a class="navbar-brand" href="#">Couponcode24 Blog Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Blogs Data</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Blogs</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                    </form>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Edit User Form -->
    <div class="container mt-5">
        <h3>Edit Blog Form For Administration</h3>
        
        <form action="<?php echo e(route('admin.updateVoter', $voter->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="form-group">
                <label for="title">Title</label>
                <input type="text" class="form-control" id="title" name="title" value="<?php echo e($voter->title); ?>" required>
            </div>

            <div class="form-group">
                <label for="content">Content</label>
                <textarea class="form-control" id="content" name="content" required><?php echo e($voter->content); ?></textarea>
            </div>

            <!-- Display the current image as clickable text -->
            <div class="form-group">
                <label for="current_image">Current Image</label>
                <?php if($voter->image): ?>
                    <div>
                        <!-- Text link to open modal -->
                        <a href="javascript:void(0);" data-toggle="modal" data-target="#imageModal" id="imageLink">Click here to view image</a>
                    </div>
                <?php else: ?>
                    <p>No image available</p>
                <?php endif; ?>
            </div>

            <!-- Image upload input -->
            <div class="form-group">
                <label for="image">Update Image</label>
                <input type="file" class="form-control-file" id="image" name="image">
            </div>

            <button type="submit" class="btn btn-primary">Update Blog</button>
        </form>
    </div>

    <!-- Modal to show the image -->
    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="imageModalLabel">View Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="modalImage" src="<?php echo e(env('IMAGE_URL') . $voter->image); ?>" alt="Current Image" class="img-fluid">
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- TinyMCE Initialization -->
    <script>
        tinymce.init({
            selector: '#content',
            height: 300,
            menubar: false,
            plugins: ['advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'print', 'preview', 'anchor', 'searchreplace', 'wordcount'],
            toolbar: 'undo redo | bold italic underline | link image | alignleft aligncenter alignright | numlist bullist | removeformat',
        });
    </script>

</body>
</html>
<?php /**PATH /home/u960678041/domains/couponcode24.com/public_html/blogAdminDashboard/resources/views/admin/voters/edit.blade.php ENDPATH**/ ?>